SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Databáze: `kontakty`
--

-- --------------------------------------------------------

--
-- Struktura tabulky `aktivita`
--

CREATE TABLE `aktivita` (
  `id` int(11) NOT NULL,
  `kontakty_id` int(11) NOT NULL,
  `vztahy_id` int(11) NOT NULL,
  `hodnota` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `doklady`
--

CREATE TABLE `doklady` (
  `id` int(10) UNSIGNED NOT NULL,
  `doklad` varchar(127) COLLATE latin2_czech_cs NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `dvere_opravneni`
--

CREATE TABLE `dvere_opravneni` (
  `id` int(10) UNSIGNED NOT NULL,
  `zkratka` varchar(1) COLLATE latin2_czech_cs NOT NULL,
  `popis` varchar(200) COLLATE latin2_czech_cs DEFAULT NULL,
  `default` int(1) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `fakulty`
--

CREATE TABLE `fakulty` (
  `id` int(10) UNSIGNED NOT NULL,
  `nazev` varchar(127) COLLATE latin2_czech_cs NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `fakulty_kontakty`
--

CREATE TABLE `fakulty_kontakty` (
  `fakulty_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `kontakty_id` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `kontakty`
--

CREATE TABLE `kontakty` (
  `id` int(11) NOT NULL,
  `prijmeni` varchar(63) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `jmeno` varchar(63) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `aprijmeni` varchar(63) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `ajmeno` varchar(63) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `titul_pred` varchar(31) COLLATE latin2_czech_cs DEFAULT NULL,
  `titul_za` varchar(31) COLLATE latin2_czech_cs DEFAULT NULL,
  `datum_narozeni` date DEFAULT NULL,
  `adresa` varchar(255) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `poznamka` text COLLATE latin2_czech_cs,
  `apoznamka` text COLLATE latin2_czech_cs,
  `web` varchar(127) COLLATE latin2_czech_cs DEFAULT NULL,
  `pid` varchar(10) COLLATE latin2_czech_cs DEFAULT NULL,
  `uco` varchar(10) COLLATE latin2_czech_cs DEFAULT NULL,
  `c_karty` varchar(64) COLLATE latin2_czech_cs DEFAULT NULL,
  `c_karty_snimac` varchar(64) COLLATE latin2_czech_cs DEFAULT NULL,
  `tel1` varchar(31) COLLATE latin2_czech_cs DEFAULT NULL,
  `tel2` varchar(31) COLLATE latin2_czech_cs DEFAULT NULL,
  `tel3` varchar(31) COLLATE latin2_czech_cs DEFAULT NULL,
  `tel4` varchar(31) COLLATE latin2_czech_cs DEFAULT NULL,
  `tel5` varchar(31) COLLATE latin2_czech_cs DEFAULT NULL,
  `email1` varchar(127) COLLATE latin2_czech_cs DEFAULT NULL,
  `email2` varchar(127) COLLATE latin2_czech_cs DEFAULT NULL,
  `email3` varchar(127) COLLATE latin2_czech_cs DEFAULT NULL,
  `zob_tel1` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `zob_tel2` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `zob_tel3` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `zob_tel4` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `zob_tel5` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `zob_email1` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `zob_email2` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `zob_email3` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `aktivni` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `dvere` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'n',
  `dvere_opravneni` int(10) UNSIGNED DEFAULT NULL,
  `isp` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'n',
  `specificdemand` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'n',
  `doklad` int(10) UNSIGNED DEFAULT NULL,
  `platnost_do` date DEFAULT NULL,
  `platnost_do_trvale` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'n',
  `login` varchar(31) COLLATE latin2_czech_cs DEFAULT NULL,
  `heslo` varchar(63) COLLATE latin2_czech_cs DEFAULT NULL,
  `opravneni_rozvrh` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `opravneni_knihovna` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `opravneni_kontakty` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `opravneni_redakcni_system` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `kategorie_ctenare` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `ctenar_prohlaseni` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'n',
  `zobrazeni_rozvrh` enum('text','grafika') COLLATE latin2_czech_cs NOT NULL DEFAULT 'text',
  `zapisovatele_administrator` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `zapisovatele_koordinator` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `zapisovatel_notebbok` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `admin` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'role for new Teiresias website',
  `revisor` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'role for new Teiresias website',
  `author` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'role for new Teiresias website',
  `translator` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'role for new Teiresias website',
  `vytvoril` int(10) UNSIGNED DEFAULT NULL,
  `vytvoreno` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `kontakty_spec_pozadavky`
--

CREATE TABLE `kontakty_spec_pozadavky` (
  `id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `posledni_aktualizace` datetime DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs COMMENT='studenti s individualni vyukou (tlumocnik, zapisovatel, ...)';

-- --------------------------------------------------------

--
-- Struktura tabulky `lekarske_zpravy`
--

CREATE TABLE `lekarske_zpravy` (
  `id` int(10) UNSIGNED NOT NULL,
  `zprava` varchar(127) COLLATE latin2_czech_cs NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `lekarske_zpravy_kontakty`
--

CREATE TABLE `lekarske_zpravy_kontakty` (
  `id` int(10) UNSIGNED NOT NULL,
  `lekarske_zpravy_id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED DEFAULT NULL,
  `vystaveno` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `notebooky`
--

CREATE TABLE `notebooky` (
  `id` int(10) UNSIGNED NOT NULL,
  `cislo` int(10) UNSIGNED NOT NULL,
  `nazev` varchar(180) COLLATE latin2_czech_cs NOT NULL,
  `fakulta_id` int(10) UNSIGNED DEFAULT NULL,
  `umisteni` varchar(180) COLLATE latin2_czech_cs NOT NULL,
  `prislusenstvi` text COLLATE latin2_czech_cs NOT NULL,
  `polygraf` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `wifi_mac` varchar(80) COLLATE latin2_czech_cs DEFAULT NULL,
  `inventarni_cislo` varchar(80) COLLATE latin2_czech_cs DEFAULT NULL,
  `seriove_cislo` varchar(80) COLLATE latin2_czech_cs DEFAULT NULL,
  `poznamka` text COLLATE latin2_czech_cs NOT NULL,
  `datum_smazani` date DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs COMMENT='Notebooky pro zapisovatele';

-- --------------------------------------------------------

--
-- Struktura tabulky `notebook_rozvrh`
--

CREATE TABLE `notebook_rozvrh` (
  `id` int(11) UNSIGNED NOT NULL,
  `rozvrh_id` int(10) UNSIGNED DEFAULT NULL,
  `predmet_id` int(11) UNSIGNED NOT NULL,
  `notebook_id` int(11) NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `notebook_termin`
--

CREATE TABLE `notebook_termin` (
  `id` int(10) UNSIGNED NOT NULL,
  `termin_id` int(10) UNSIGNED NOT NULL,
  `notebook_id` int(10) NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `postizeni`
--

CREATE TABLE `postizeni` (
  `id` smallint(5) UNSIGNED NOT NULL,
  `typ` varchar(127) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `code` varchar(10) COLLATE latin2_czech_cs NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `postizeni_kontakty`
--

CREATE TABLE `postizeni_kontakty` (
  `postizeni_id` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `kontakty_id` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `kategorie_postizeni_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `postizeni_podkategorie`
--

CREATE TABLE `postizeni_podkategorie` (
  `podkategorie_id` int(10) UNSIGNED NOT NULL,
  `postizeni_id` int(10) UNSIGNED NOT NULL,
  `podkategorie_postizeni_typ` varchar(100) COLLATE latin2_czech_cs NOT NULL,
  `podkategorie_postizeni_code` varchar(10) COLLATE latin2_czech_cs NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `pozadavek`
--

CREATE TABLE `pozadavek` (
  `id` int(10) UNSIGNED NOT NULL,
  `role` varchar(180) COLLATE latin2_czech_cs NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `predmet`
--

CREATE TABLE `predmet` (
  `id` int(10) UNSIGNED NOT NULL,
  `is_id` int(10) UNSIGNED NOT NULL,
  `kod_prefix` varchar(80) COLLATE latin2_czech_cs NOT NULL,
  `kod_sufix` varchar(80) COLLATE latin2_czech_cs DEFAULT NULL,
  `nazev` varchar(255) COLLATE latin2_czech_cs NOT NULL,
  `nazev_stary` varchar(255) COLLATE latin2_czech_cs DEFAULT NULL,
  `anglicky` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `poznamka` text COLLATE latin2_czech_cs,
  `poznamka_soukroma` text COLLATE latin2_czech_cs,
  `individualni_vyuka` int(11) NOT NULL DEFAULT '0',
  `posledni_aktualizace` datetime DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `predmet_studenti`
--

CREATE TABLE `predmet_studenti` (
  `id` int(10) UNSIGNED NOT NULL,
  `predmet_id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `zruseno` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `rozvrh`
--

CREATE TABLE `rozvrh` (
  `id` int(10) UNSIGNED NOT NULL,
  `predmet_id` int(10) UNSIGNED NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `den_v_tydnu` int(10) UNSIGNED DEFAULT NULL COMMENT '1 - Po, 2 - Út, ...',
  `zacatek` time DEFAULT NULL,
  `konec` time DEFAULT NULL,
  `nenabizet` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `typ_vyuky` int(10) UNSIGNED DEFAULT NULL COMMENT '1 - každý týden, 2 - každý sudý týden, 3 - každý lichý týden, 4 - blokově',
  `polygraf` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `ucitele` text COLLATE latin2_czech_cs,
  `ucebny` text COLLATE latin2_czech_cs,
  `ucebny_adresy` text COLLATE latin2_czech_cs,
  `posledni_aktualizace` datetime DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `rozvrh_pozadavek`
--

CREATE TABLE `rozvrh_pozadavek` (
  `id` int(10) UNSIGNED NOT NULL,
  `predmet_id` int(10) UNSIGNED NOT NULL,
  `rozvrh_id` int(10) UNSIGNED DEFAULT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `pozadavek_id` int(11) NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `prideleno` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sessions`
--

CREATE TABLE `sessions` (
  `id` varchar(32) COLLATE latin2_czech_cs NOT NULL,
  `access` int(10) UNSIGNED DEFAULT NULL,
  `data` text COLLATE latin2_czech_cs
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_device`
--

CREATE TABLE `sl_device` (
  `id` int(11) NOT NULL,
  `period_id` int(11) DEFAULT NULL,
  `number` int(10) UNSIGNED NOT NULL,
  `name` varchar(180) COLLATE latin2_czech_cs NOT NULL,
  `location` varchar(180) COLLATE latin2_czech_cs NOT NULL,
  `accessories` text COLLATE latin2_czech_cs NOT NULL,
  `polygraf` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `wifi_mac` varchar(80) COLLATE latin2_czech_cs DEFAULT NULL,
  `inventory_number` varchar(80) COLLATE latin2_czech_cs DEFAULT NULL,
  `serial_number` varchar(80) COLLATE latin2_czech_cs DEFAULT NULL,
  `note` text COLLATE latin2_czech_cs,
  `deleted_date` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_device_term`
--

CREATE TABLE `sl_device_term` (
  `id` int(10) UNSIGNED NOT NULL,
  `device_id` int(11) NOT NULL,
  `term_id` int(11) NOT NULL,
  `period_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_lecture`
--

CREATE TABLE `sl_lecture` (
  `id` int(11) NOT NULL,
  `period_id` int(11) NOT NULL,
  `is_id` int(10) UNSIGNED DEFAULT NULL,
  `code` varchar(80) COLLATE latin2_czech_cs NOT NULL,
  `name` varchar(255) COLLATE latin2_czech_cs NOT NULL,
  `english` int(1) NOT NULL DEFAULT '0',
  `checked_in_is` int(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_lecturer`
--

CREATE TABLE `sl_lecturer` (
  `id` int(11) NOT NULL,
  `is_id` int(10) UNSIGNED DEFAULT NULL,
  `is_link` varchar(80) COLLATE latin2_czech_cs DEFAULT NULL,
  `name` varchar(120) COLLATE latin2_czech_cs NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_lecture_request`
--

CREATE TABLE `sl_lecture_request` (
  `id` int(11) NOT NULL,
  `lecture_id` int(11) NOT NULL,
  `kontakty_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `period_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_lecture_service`
--

CREATE TABLE `sl_lecture_service` (
  `id` int(11) NOT NULL,
  `lecture_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `attribute` enum('public_note','private_note','polygraf') COLLATE latin2_czech_cs NOT NULL,
  `value` text COLLATE latin2_czech_cs NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_lecture_student`
--

CREATE TABLE `sl_lecture_student` (
  `id` int(11) NOT NULL,
  `lecture_id` int(11) NOT NULL,
  `kontakty_id` int(11) NOT NULL,
  `period_id` int(11) NOT NULL,
  `canceled` int(1) DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_log`
--

CREATE TABLE `sl_log` (
  `id` int(11) NOT NULL,
  `schedule_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `service_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `changes` text COLLATE latin2_czech_cs,
  `ip` varchar(255) COLLATE latin2_czech_cs NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_period`
--

CREATE TABLE `sl_period` (
  `id` int(11) NOT NULL,
  `is_id` int(11) DEFAULT NULL,
  `period` varchar(80) COLLATE latin2_czech_cs NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_room`
--

CREATE TABLE `sl_room` (
  `id` int(11) NOT NULL,
  `period_id` int(10) UNSIGNED NOT NULL,
  `is_id` int(10) UNSIGNED DEFAULT NULL,
  `is_link` varchar(255) COLLATE latin2_czech_cs DEFAULT NULL,
  `name` varchar(255) COLLATE latin2_czech_cs DEFAULT NULL,
  `address` text COLLATE latin2_czech_cs,
  `specification` text COLLATE latin2_czech_cs,
  `code` varchar(255) COLLATE latin2_czech_cs DEFAULT NULL,
  `checked` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_schedule`
--

CREATE TABLE `sl_schedule` (
  `id` int(11) NOT NULL,
  `lecture_id` int(11) NOT NULL,
  `period_id` int(11) NOT NULL,
  `type` int(1) DEFAULT NULL,
  `day` int(1) DEFAULT NULL,
  `time_from` time DEFAULT NULL,
  `time_to` time DEFAULT NULL,
  `from_is` int(1) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_schedule_lecturer`
--

CREATE TABLE `sl_schedule_lecturer` (
  `id` int(11) NOT NULL,
  `schedule_id` int(11) NOT NULL,
  `lecturer_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_schedule_room`
--

CREATE TABLE `sl_schedule_room` (
  `id` int(11) NOT NULL,
  `schedule_id` int(11) NOT NULL,
  `room_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_schedule_service`
--

CREATE TABLE `sl_schedule_service` (
  `id` int(11) NOT NULL,
  `schedule_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `servicers` int(10) DEFAULT '1',
  `not_offer` int(1) DEFAULT '0',
  `polygraf` int(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_service`
--

CREATE TABLE `sl_service` (
  `id` int(11) NOT NULL,
  `service` varchar(80) COLLATE latin2_czech_cs NOT NULL,
  `mail_from` varchar(250) COLLATE latin2_czech_cs DEFAULT NULL,
  `mail_from_name` varchar(250) COLLATE latin2_czech_cs DEFAULT NULL,
  `mail_regards` text COLLATE latin2_czech_cs NOT NULL,
  `two` int(10) UNSIGNED DEFAULT NULL COMMENT 'two servicers from time',
  `display_for_not_assigned` int(10) UNSIGNED DEFAULT NULL COMMENT 'display assigned servicers for not assigned servicers',
  `item_notebooks` int(1) DEFAULT NULL,
  `item_for_external` int(1) DEFAULT NULL,
  `order_assigning_needs` int(10) UNSIGNED DEFAULT NULL,
  `order_lecture_terms` int(1) DEFAULT NULL,
  `order_lecture_students` int(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_student_need_service`
--

CREATE TABLE `sl_student_need_service` (
  `id` int(11) NOT NULL,
  `kontakty_id` int(11) NOT NULL,
  `period_id` int(11) NOT NULL,
  `last_update` datetime DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_term`
--

CREATE TABLE `sl_term` (
  `id` int(11) NOT NULL,
  `schedule_id` int(11) NOT NULL,
  `period_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `once` int(1) DEFAULT '0',
  `from_is` int(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_term_request`
--

CREATE TABLE `sl_term_request` (
  `id` int(11) NOT NULL,
  `term_id` int(11) NOT NULL,
  `kontakty_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `period_id` int(11) NOT NULL,
  `note` text COLLATE latin2_czech_cs,
  `assigned` int(1) DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_term_service`
--

CREATE TABLE `sl_term_service` (
  `id` int(11) NOT NULL,
  `term_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `note` text COLLATE latin2_czech_cs,
  `schedule_first` int(1) DEFAULT '0',
  `servicers` int(10) UNSIGNED DEFAULT NULL,
  `absence` int(1) DEFAULT '0',
  `not_offer` int(1) DEFAULT '0',
  `enforce` int(1) NOT NULL DEFAULT '0',
  `for_external` int(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `sl_user_evaluation`
--

CREATE TABLE `sl_user_evaluation` (
  `id` int(11) UNSIGNED NOT NULL,
  `kontakty_id` int(10) NOT NULL,
  `name` varchar(200) COLLATE latin2_czech_cs DEFAULT NULL,
  `keystrokes` int(10) UNSIGNED DEFAULT NULL,
  `language_overview` int(10) UNSIGNED DEFAULT NULL,
  `general_overview` int(10) UNSIGNED DEFAULT NULL,
  `note` text COLLATE latin2_czech_cs,
  `date_of_event` date NOT NULL,
  `author` int(11) NOT NULL,
  `edited_date` datetime DEFAULT NULL COMMENT 'date of last editation',
  `edited_user` int(11) DEFAULT NULL,
  `deleted_date` datetime DEFAULT NULL,
  `deleted_user` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `stav_studia`
--

CREATE TABLE `stav_studia` (
  `studium_id` int(10) NOT NULL DEFAULT '0',
  `akce` smallint(3) NOT NULL DEFAULT '0',
  `datum` date NOT NULL DEFAULT '0000-00-00',
  `poznamka` varchar(100) COLLATE latin2_czech_cs DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `studia`
--

CREATE TABLE `studia` (
  `student_id` int(10) NOT NULL DEFAULT '0',
  `studium_id` int(10) NOT NULL,
  `fakulta` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `termin_vyuky`
--

CREATE TABLE `termin_vyuky` (
  `id` int(10) UNSIGNED NOT NULL,
  `rozvrh_id` int(10) UNSIGNED NOT NULL,
  `datum` date NOT NULL,
  `jednorazove` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `nenabizet` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `tlum_kontakty_spec_pozadavky`
--

CREATE TABLE `tlum_kontakty_spec_pozadavky` (
  `id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `posledni_aktualizace` datetime DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs COMMENT='studenti s individualni vyukou (tlumocnik, zapisovatel, ...)';

-- --------------------------------------------------------

--
-- Struktura tabulky `tlum_predmet`
--

CREATE TABLE `tlum_predmet` (
  `id` int(10) UNSIGNED NOT NULL,
  `is_id` int(10) UNSIGNED NOT NULL,
  `kod_prefix` varchar(80) COLLATE latin2_czech_cs NOT NULL,
  `kod_sufix` varchar(80) COLLATE latin2_czech_cs DEFAULT NULL,
  `nazev` varchar(255) COLLATE latin2_czech_cs NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `tlum_predmet_studenti`
--

CREATE TABLE `tlum_predmet_studenti` (
  `id` int(10) UNSIGNED NOT NULL,
  `predmet_id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `zruseno` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `tlum_rozvrh`
--

CREATE TABLE `tlum_rozvrh` (
  `id` int(10) UNSIGNED NOT NULL,
  `predmet_id` int(10) UNSIGNED NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `den_v_tydnu` int(10) UNSIGNED DEFAULT NULL COMMENT '1 - Po, 2 - Út, ...',
  `zacatek` time DEFAULT NULL,
  `konec` time DEFAULT NULL,
  `nenabizet` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `ucitele` text COLLATE latin2_czech_cs,
  `ucebny` text COLLATE latin2_czech_cs,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `tlum_rozvrh_pozadavek`
--

CREATE TABLE `tlum_rozvrh_pozadavek` (
  `id` int(10) UNSIGNED NOT NULL,
  `predmet_id` int(10) UNSIGNED NOT NULL,
  `rozvrh_id` int(10) UNSIGNED DEFAULT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `pozadavek_id` int(11) NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `prideleno` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `tlum_termin_vyuky`
--

CREATE TABLE `tlum_termin_vyuky` (
  `id` int(10) UNSIGNED NOT NULL,
  `rozvrh_id` int(10) UNSIGNED NOT NULL,
  `datum` date NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `vztahy`
--

CREATE TABLE `vztahy` (
  `id` int(10) UNSIGNED NOT NULL,
  `nazev` varchar(127) COLLATE latin2_czech_cs NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `vztahy_kontakty`
--

CREATE TABLE `vztahy_kontakty` (
  `vztahy_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `kontakty_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `roky` varchar(255) COLLATE latin2_czech_cs DEFAULT NULL,
  `instituce` varchar(255) COLLATE latin2_czech_cs DEFAULT NULL,
  `ainstituce` varchar(255) COLLATE latin2_czech_cs DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `zapisovatele_hodnoceni`
--

CREATE TABLE `zapisovatele_hodnoceni` (
  `id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `nazev` varchar(200) COLLATE latin2_czech_cs DEFAULT NULL,
  `uhozu` int(10) UNSIGNED DEFAULT NULL,
  `jazykova_obratnost` int(10) UNSIGNED DEFAULT NULL,
  `vseobecny_prehled` int(10) UNSIGNED DEFAULT NULL,
  `poznamka` text COLLATE latin2_czech_cs,
  `datum_konani` date NOT NULL,
  `zadal` int(10) UNSIGNED NOT NULL,
  `datum_upravy` datetime DEFAULT NULL COMMENT 'datum poslední úpravy',
  `upravil` int(10) UNSIGNED DEFAULT NULL,
  `datum_smazani` datetime DEFAULT NULL,
  `smazal` int(10) UNSIGNED DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `zapisovatele_zadosti_rozvrh`
--

CREATE TABLE `zapisovatele_zadosti_rozvrh` (
  `id` int(10) UNSIGNED NOT NULL,
  `predmet_id` int(10) UNSIGNED NOT NULL,
  `rozvrh_id` int(10) UNSIGNED DEFAULT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `role_id` int(10) UNSIGNED DEFAULT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `zadost_poznamka` text CHARACTER SET utf8 COLLATE utf8_czech_ci,
  `pridelen` int(10) UNSIGNED DEFAULT NULL,
  `prideleni_poznamka` text CHARACTER SET utf8 COLLATE utf8_czech_ci,
  `datum_prideleni` datetime DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `zapisovatele_zadosti_termin`
--

CREATE TABLE `zapisovatele_zadosti_termin` (
  `id` int(10) UNSIGNED NOT NULL,
  `termin_id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `role_id` int(10) UNSIGNED DEFAULT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `zadost_poznamka` text CHARACTER SET utf8 COLLATE utf8_czech_ci,
  `pridelen` int(10) UNSIGNED DEFAULT NULL,
  `prideleni_poznamka` text CHARACTER SET utf8 COLLATE utf8_czech_ci,
  `datum_prideleni` datetime DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `zmeny`
--

CREATE TABLE `zmeny` (
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `kdo` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `koho` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `_smaz_rozvrh_notebook`
--

CREATE TABLE `_smaz_rozvrh_notebook` (
  `id` int(11) NOT NULL,
  `rozvrh_id` int(10) UNSIGNED DEFAULT NULL,
  `predmet_id` int(11) UNSIGNED NOT NULL,
  `notebook_id` int(11) NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `_smaz_termin_asistence`
--

CREATE TABLE `_smaz_termin_asistence` (
  `id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `termin_id` int(10) UNSIGNED NOT NULL,
  `asistent_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `_zapisovatele_zadosti`
--

CREATE TABLE `_zapisovatele_zadosti` (
  `id` int(10) UNSIGNED NOT NULL,
  `predmet_id` int(10) UNSIGNED NOT NULL,
  `rozvrh_id` int(10) UNSIGNED DEFAULT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL,
  `obdobi` int(10) UNSIGNED NOT NULL,
  `pridelen` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `pridelen_datum` datetime DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

--
-- Klíče pro exportované tabulky
--

--
-- Klíče pro tabulku `aktivita`
--
ALTER TABLE `aktivita`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique` (`kontakty_id`,`vztahy_id`);

--
-- Klíče pro tabulku `doklady`
--
ALTER TABLE `doklady`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `dvere_opravneni`
--
ALTER TABLE `dvere_opravneni`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `fakulty`
--
ALTER TABLE `fakulty`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `fakulty_kontakty`
--
ALTER TABLE `fakulty_kontakty`
  ADD PRIMARY KEY (`fakulty_id`,`kontakty_id`);

--
-- Klíče pro tabulku `kontakty`
--
ALTER TABLE `kontakty`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `kontakty_spec_pozadavky`
--
ALTER TABLE `kontakty_spec_pozadavky`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `lekarske_zpravy`
--
ALTER TABLE `lekarske_zpravy`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `lekarske_zpravy_kontakty`
--
ALTER TABLE `lekarske_zpravy_kontakty`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `notebooky`
--
ALTER TABLE `notebooky`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `notebook_rozvrh`
--
ALTER TABLE `notebook_rozvrh`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `notebook_termin`
--
ALTER TABLE `notebook_termin`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `postizeni`
--
ALTER TABLE `postizeni`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `postizeni_kontakty`
--
ALTER TABLE `postizeni_kontakty`
  ADD PRIMARY KEY (`postizeni_id`,`kontakty_id`);

--
-- Klíče pro tabulku `postizeni_podkategorie`
--
ALTER TABLE `postizeni_podkategorie`
  ADD PRIMARY KEY (`podkategorie_id`);

--
-- Klíče pro tabulku `pozadavek`
--
ALTER TABLE `pozadavek`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `predmet`
--
ALTER TABLE `predmet`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `predmet_studenti`
--
ALTER TABLE `predmet_studenti`
  ADD PRIMARY KEY (`id`),
  ADD KEY `predmet_id_kontakty_id` (`predmet_id`,`kontakty_id`);

--
-- Klíče pro tabulku `rozvrh`
--
ALTER TABLE `rozvrh`
  ADD PRIMARY KEY (`id`),
  ADD KEY `predmet_id` (`predmet_id`),
  ADD KEY `obdobi` (`obdobi`);

--
-- Klíče pro tabulku `rozvrh_pozadavek`
--
ALTER TABLE `rozvrh_pozadavek`
  ADD PRIMARY KEY (`id`),
  ADD KEY `obdobi` (`obdobi`),
  ADD KEY `kontakty_id` (`kontakty_id`);

--
-- Klíče pro tabulku `sessions`
--
ALTER TABLE `sessions`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `sl_device`
--
ALTER TABLE `sl_device`
  ADD PRIMARY KEY (`id`),
  ADD KEY `period_id` (`period_id`);

--
-- Klíče pro tabulku `sl_device_term`
--
ALTER TABLE `sl_device_term`
  ADD PRIMARY KEY (`id`),
  ADD KEY `device_id` (`device_id`),
  ADD KEY `term_id` (`term_id`),
  ADD KEY `period_id` (`period_id`),
  ADD KEY `service_id` (`service_id`);

--
-- Klíče pro tabulku `sl_lecture`
--
ALTER TABLE `sl_lecture`
  ADD PRIMARY KEY (`id`),
  ADD KEY `period_id` (`period_id`);

--
-- Klíče pro tabulku `sl_lecturer`
--
ALTER TABLE `sl_lecturer`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `sl_lecture_request`
--
ALTER TABLE `sl_lecture_request`
  ADD PRIMARY KEY (`id`),
  ADD KEY `lecture_id` (`lecture_id`),
  ADD KEY `kontakty_id` (`kontakty_id`),
  ADD KEY `service_id` (`service_id`),
  ADD KEY `period_id` (`period_id`);

--
-- Klíče pro tabulku `sl_lecture_service`
--
ALTER TABLE `sl_lecture_service`
  ADD PRIMARY KEY (`id`),
  ADD KEY `lecture_id` (`lecture_id`),
  ADD KEY `service_id` (`service_id`);

--
-- Klíče pro tabulku `sl_lecture_student`
--
ALTER TABLE `sl_lecture_student`
  ADD PRIMARY KEY (`id`),
  ADD KEY `lecture_id` (`lecture_id`),
  ADD KEY `kontakty_id` (`kontakty_id`),
  ADD KEY `period_id` (`period_id`);

--
-- Klíče pro tabulku `sl_log`
--
ALTER TABLE `sl_log`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `sl_period`
--
ALTER TABLE `sl_period`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `sl_room`
--
ALTER TABLE `sl_room`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `sl_schedule`
--
ALTER TABLE `sl_schedule`
  ADD PRIMARY KEY (`id`),
  ADD KEY `lecture_id` (`lecture_id`),
  ADD KEY `period_id` (`period_id`);

--
-- Klíče pro tabulku `sl_schedule_lecturer`
--
ALTER TABLE `sl_schedule_lecturer`
  ADD PRIMARY KEY (`id`),
  ADD KEY `schedule_id` (`schedule_id`),
  ADD KEY `lecturer_id` (`lecturer_id`);

--
-- Klíče pro tabulku `sl_schedule_room`
--
ALTER TABLE `sl_schedule_room`
  ADD PRIMARY KEY (`id`),
  ADD KEY `schedule_id` (`schedule_id`),
  ADD KEY `room_id` (`room_id`);

--
-- Klíče pro tabulku `sl_schedule_service`
--
ALTER TABLE `sl_schedule_service`
  ADD PRIMARY KEY (`id`),
  ADD KEY `schedule_id` (`schedule_id`),
  ADD KEY `service_id` (`service_id`);

--
-- Klíče pro tabulku `sl_service`
--
ALTER TABLE `sl_service`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `sl_student_need_service`
--
ALTER TABLE `sl_student_need_service`
  ADD PRIMARY KEY (`id`),
  ADD KEY `kontakty_id` (`kontakty_id`),
  ADD KEY `period_id` (`period_id`);

--
-- Klíče pro tabulku `sl_term`
--
ALTER TABLE `sl_term`
  ADD PRIMARY KEY (`id`),
  ADD KEY `schedule_id` (`schedule_id`),
  ADD KEY `period_id` (`period_id`);

--
-- Klíče pro tabulku `sl_term_request`
--
ALTER TABLE `sl_term_request`
  ADD PRIMARY KEY (`id`),
  ADD KEY `term_id` (`term_id`),
  ADD KEY `service_id` (`service_id`),
  ADD KEY `period_id` (`period_id`);

--
-- Klíče pro tabulku `sl_term_service`
--
ALTER TABLE `sl_term_service`
  ADD PRIMARY KEY (`id`),
  ADD KEY `term_id` (`term_id`),
  ADD KEY `service_id` (`service_id`);

--
-- Klíče pro tabulku `sl_user_evaluation`
--
ALTER TABLE `sl_user_evaluation`
  ADD PRIMARY KEY (`id`),
  ADD KEY `kontakty_id` (`kontakty_id`),
  ADD KEY `author` (`author`),
  ADD KEY `edited_user` (`edited_user`),
  ADD KEY `deleted_user` (`deleted_user`);

--
-- Klíče pro tabulku `studia`
--
ALTER TABLE `studia`
  ADD PRIMARY KEY (`studium_id`);

--
-- Klíče pro tabulku `termin_vyuky`
--
ALTER TABLE `termin_vyuky`
  ADD PRIMARY KEY (`id`),
  ADD KEY `termin_id` (`rozvrh_id`);

--
-- Klíče pro tabulku `tlum_kontakty_spec_pozadavky`
--
ALTER TABLE `tlum_kontakty_spec_pozadavky`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `tlum_predmet`
--
ALTER TABLE `tlum_predmet`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `tlum_predmet_studenti`
--
ALTER TABLE `tlum_predmet_studenti`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `tlum_rozvrh`
--
ALTER TABLE `tlum_rozvrh`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `tlum_rozvrh_pozadavek`
--
ALTER TABLE `tlum_rozvrh_pozadavek`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `tlum_termin_vyuky`
--
ALTER TABLE `tlum_termin_vyuky`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `vztahy`
--
ALTER TABLE `vztahy`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `vztahy_kontakty`
--
ALTER TABLE `vztahy_kontakty`
  ADD PRIMARY KEY (`vztahy_id`,`kontakty_id`);

--
-- Klíče pro tabulku `zapisovatele_hodnoceni`
--
ALTER TABLE `zapisovatele_hodnoceni`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `zapisovatele_zadosti_rozvrh`
--
ALTER TABLE `zapisovatele_zadosti_rozvrh`
  ADD PRIMARY KEY (`id`),
  ADD KEY `obdobi` (`obdobi`);

--
-- Klíče pro tabulku `zapisovatele_zadosti_termin`
--
ALTER TABLE `zapisovatele_zadosti_termin`
  ADD PRIMARY KEY (`id`),
  ADD KEY `obdobi` (`obdobi`);

--
-- Klíče pro tabulku `zmeny`
--
ALTER TABLE `zmeny`
  ADD PRIMARY KEY (`timestamp`,`kdo`,`koho`);

--
-- Klíče pro tabulku `_smaz_rozvrh_notebook`
--
ALTER TABLE `_smaz_rozvrh_notebook`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `_smaz_termin_asistence`
--
ALTER TABLE `_smaz_termin_asistence`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `_zapisovatele_zadosti`
--
ALTER TABLE `_zapisovatele_zadosti`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT pro tabulky
--

--
-- AUTO_INCREMENT pro tabulku `aktivita`
--
ALTER TABLE `aktivita`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8533;
--
-- AUTO_INCREMENT pro tabulku `doklady`
--
ALTER TABLE `doklady`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;
--
-- AUTO_INCREMENT pro tabulku `dvere_opravneni`
--
ALTER TABLE `dvere_opravneni`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;
--
-- AUTO_INCREMENT pro tabulku `fakulty`
--
ALTER TABLE `fakulty`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;
--
-- AUTO_INCREMENT pro tabulku `kontakty`
--
ALTER TABLE `kontakty`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7539;
--
-- AUTO_INCREMENT pro tabulku `kontakty_spec_pozadavky`
--
ALTER TABLE `kontakty_spec_pozadavky`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=609;
--
-- AUTO_INCREMENT pro tabulku `lekarske_zpravy`
--
ALTER TABLE `lekarske_zpravy`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
--
-- AUTO_INCREMENT pro tabulku `lekarske_zpravy_kontakty`
--
ALTER TABLE `lekarske_zpravy_kontakty`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19787;
--
-- AUTO_INCREMENT pro tabulku `notebooky`
--
ALTER TABLE `notebooky`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=31;
--
-- AUTO_INCREMENT pro tabulku `notebook_rozvrh`
--
ALTER TABLE `notebook_rozvrh`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1011;
--
-- AUTO_INCREMENT pro tabulku `notebook_termin`
--
ALTER TABLE `notebook_termin`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1227;
--
-- AUTO_INCREMENT pro tabulku `postizeni`
--
ALTER TABLE `postizeni`
  MODIFY `id` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT pro tabulku `postizeni_podkategorie`
--
ALTER TABLE `postizeni_podkategorie`
  MODIFY `podkategorie_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8911;
--
-- AUTO_INCREMENT pro tabulku `pozadavek`
--
ALTER TABLE `pozadavek`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT pro tabulku `predmet`
--
ALTER TABLE `predmet`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2973;
--
-- AUTO_INCREMENT pro tabulku `predmet_studenti`
--
ALTER TABLE `predmet_studenti`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5131;
--
-- AUTO_INCREMENT pro tabulku `rozvrh`
--
ALTER TABLE `rozvrh`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3039;
--
-- AUTO_INCREMENT pro tabulku `rozvrh_pozadavek`
--
ALTER TABLE `rozvrh_pozadavek`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13055;
--
-- AUTO_INCREMENT pro tabulku `sl_device`
--
ALTER TABLE `sl_device`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=81;
--
-- AUTO_INCREMENT pro tabulku `sl_device_term`
--
ALTER TABLE `sl_device_term`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9143;
--
-- AUTO_INCREMENT pro tabulku `sl_lecture`
--
ALTER TABLE `sl_lecture`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4241;
--
-- AUTO_INCREMENT pro tabulku `sl_lecturer`
--
ALTER TABLE `sl_lecturer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `sl_lecture_request`
--
ALTER TABLE `sl_lecture_request`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13801;
--
-- AUTO_INCREMENT pro tabulku `sl_lecture_service`
--
ALTER TABLE `sl_lecture_service`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1303;
--
-- AUTO_INCREMENT pro tabulku `sl_lecture_student`
--
ALTER TABLE `sl_lecture_student`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5675;
--
-- AUTO_INCREMENT pro tabulku `sl_log`
--
ALTER TABLE `sl_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1499;
--
-- AUTO_INCREMENT pro tabulku `sl_period`
--
ALTER TABLE `sl_period`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
--
-- AUTO_INCREMENT pro tabulku `sl_room`
--
ALTER TABLE `sl_room`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1245;
--
-- AUTO_INCREMENT pro tabulku `sl_schedule`
--
ALTER TABLE `sl_schedule`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4003;
--
-- AUTO_INCREMENT pro tabulku `sl_schedule_lecturer`
--
ALTER TABLE `sl_schedule_lecturer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `sl_schedule_room`
--
ALTER TABLE `sl_schedule_room`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14775;
--
-- AUTO_INCREMENT pro tabulku `sl_schedule_service`
--
ALTER TABLE `sl_schedule_service`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `sl_service`
--
ALTER TABLE `sl_service`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT pro tabulku `sl_student_need_service`
--
ALTER TABLE `sl_student_need_service`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=759;
--
-- AUTO_INCREMENT pro tabulku `sl_term`
--
ALTER TABLE `sl_term`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=33159;
--
-- AUTO_INCREMENT pro tabulku `sl_term_request`
--
ALTER TABLE `sl_term_request`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=45543;
--
-- AUTO_INCREMENT pro tabulku `sl_term_service`
--
ALTER TABLE `sl_term_service`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=65983;
--
-- AUTO_INCREMENT pro tabulku `sl_user_evaluation`
--
ALTER TABLE `sl_user_evaluation`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `studia`
--
ALTER TABLE `studia`
  MODIFY `studium_id` int(10) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT pro tabulku `termin_vyuky`
--
ALTER TABLE `termin_vyuky`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=27939;
--
-- AUTO_INCREMENT pro tabulku `tlum_kontakty_spec_pozadavky`
--
ALTER TABLE `tlum_kontakty_spec_pozadavky`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=99;
--
-- AUTO_INCREMENT pro tabulku `tlum_predmet`
--
ALTER TABLE `tlum_predmet`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=495;
--
-- AUTO_INCREMENT pro tabulku `tlum_predmet_studenti`
--
ALTER TABLE `tlum_predmet_studenti`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=755;
--
-- AUTO_INCREMENT pro tabulku `tlum_rozvrh`
--
ALTER TABLE `tlum_rozvrh`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=377;
--
-- AUTO_INCREMENT pro tabulku `tlum_rozvrh_pozadavek`
--
ALTER TABLE `tlum_rozvrh_pozadavek`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=923;
--
-- AUTO_INCREMENT pro tabulku `tlum_termin_vyuky`
--
ALTER TABLE `tlum_termin_vyuky`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3617;
--
-- AUTO_INCREMENT pro tabulku `vztahy`
--
ALTER TABLE `vztahy`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;
--
-- AUTO_INCREMENT pro tabulku `zapisovatele_hodnoceni`
--
ALTER TABLE `zapisovatele_hodnoceni`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=147;
--
-- AUTO_INCREMENT pro tabulku `zapisovatele_zadosti_rozvrh`
--
ALTER TABLE `zapisovatele_zadosti_rozvrh`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2385;
--
-- AUTO_INCREMENT pro tabulku `zapisovatele_zadosti_termin`
--
ALTER TABLE `zapisovatele_zadosti_termin`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3499;
--
-- AUTO_INCREMENT pro tabulku `_smaz_rozvrh_notebook`
--
ALTER TABLE `_smaz_rozvrh_notebook`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `_smaz_termin_asistence`
--
ALTER TABLE `_smaz_termin_asistence`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `_zapisovatele_zadosti`
--
ALTER TABLE `_zapisovatele_zadosti`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=107;
--
-- Omezení pro exportované tabulky
--

--
-- Omezení pro tabulku `sl_device`
--
ALTER TABLE `sl_device`
  ADD CONSTRAINT `sl_device_ibfk_1` FOREIGN KEY (`period_id`) REFERENCES `sl_period` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_device_term`
--
ALTER TABLE `sl_device_term`
  ADD CONSTRAINT `sl_device_term_ibfk_1` FOREIGN KEY (`device_id`) REFERENCES `sl_device` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_device_term_ibfk_2` FOREIGN KEY (`term_id`) REFERENCES `sl_term` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_device_term_ibfk_3` FOREIGN KEY (`period_id`) REFERENCES `sl_period` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_device_term_ibfk_4` FOREIGN KEY (`service_id`) REFERENCES `sl_service` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_lecture`
--
ALTER TABLE `sl_lecture`
  ADD CONSTRAINT `sl_lecture_ibfk_1` FOREIGN KEY (`period_id`) REFERENCES `sl_period` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_lecture_request`
--
ALTER TABLE `sl_lecture_request`
  ADD CONSTRAINT `sl_lecture_request_ibfk_1` FOREIGN KEY (`lecture_id`) REFERENCES `sl_lecture` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_lecture_request_ibfk_2` FOREIGN KEY (`kontakty_id`) REFERENCES `kontakty` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_lecture_request_ibfk_3` FOREIGN KEY (`service_id`) REFERENCES `sl_service` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_lecture_request_ibfk_4` FOREIGN KEY (`period_id`) REFERENCES `sl_period` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_lecture_service`
--
ALTER TABLE `sl_lecture_service`
  ADD CONSTRAINT `sl_lecture_service_ibfk_1` FOREIGN KEY (`lecture_id`) REFERENCES `sl_lecture` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_lecture_service_ibfk_2` FOREIGN KEY (`service_id`) REFERENCES `sl_service` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_lecture_student`
--
ALTER TABLE `sl_lecture_student`
  ADD CONSTRAINT `sl_lecture_student_ibfk_1` FOREIGN KEY (`lecture_id`) REFERENCES `sl_lecture` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_lecture_student_ibfk_2` FOREIGN KEY (`kontakty_id`) REFERENCES `kontakty` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_lecture_student_ibfk_3` FOREIGN KEY (`period_id`) REFERENCES `sl_period` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_schedule`
--
ALTER TABLE `sl_schedule`
  ADD CONSTRAINT `sl_schedule_ibfk_1` FOREIGN KEY (`lecture_id`) REFERENCES `sl_lecture` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_schedule_ibfk_2` FOREIGN KEY (`period_id`) REFERENCES `sl_period` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_schedule_lecturer`
--
ALTER TABLE `sl_schedule_lecturer`
  ADD CONSTRAINT `sl_schedule_lecturer_ibfk_1` FOREIGN KEY (`schedule_id`) REFERENCES `sl_schedule` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_schedule_lecturer_ibfk_2` FOREIGN KEY (`lecturer_id`) REFERENCES `sl_lecturer` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_schedule_room`
--
ALTER TABLE `sl_schedule_room`
  ADD CONSTRAINT `sl_schedule_room_ibfk_1` FOREIGN KEY (`schedule_id`) REFERENCES `sl_schedule` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_schedule_room_ibfk_2` FOREIGN KEY (`room_id`) REFERENCES `sl_room` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_schedule_service`
--
ALTER TABLE `sl_schedule_service`
  ADD CONSTRAINT `sl_schedule_service_ibfk_1` FOREIGN KEY (`schedule_id`) REFERENCES `sl_schedule` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_schedule_service_ibfk_2` FOREIGN KEY (`service_id`) REFERENCES `sl_service` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_student_need_service`
--
ALTER TABLE `sl_student_need_service`
  ADD CONSTRAINT `sl_student_need_service_ibfk_1` FOREIGN KEY (`kontakty_id`) REFERENCES `kontakty` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_student_need_service_ibfk_2` FOREIGN KEY (`period_id`) REFERENCES `sl_period` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_term`
--
ALTER TABLE `sl_term`
  ADD CONSTRAINT `sl_term_ibfk_1` FOREIGN KEY (`schedule_id`) REFERENCES `sl_schedule` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_term_ibfk_2` FOREIGN KEY (`period_id`) REFERENCES `sl_period` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_term_request`
--
ALTER TABLE `sl_term_request`
  ADD CONSTRAINT `sl_term_request_ibfk_1` FOREIGN KEY (`term_id`) REFERENCES `sl_term` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_term_request_ibfk_2` FOREIGN KEY (`service_id`) REFERENCES `sl_service` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_term_request_ibfk_3` FOREIGN KEY (`period_id`) REFERENCES `sl_period` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_term_service`
--
ALTER TABLE `sl_term_service`
  ADD CONSTRAINT `sl_term_service_ibfk_1` FOREIGN KEY (`term_id`) REFERENCES `sl_term` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_term_service_ibfk_2` FOREIGN KEY (`service_id`) REFERENCES `sl_service` (`id`) ON UPDATE CASCADE;

--
-- Omezení pro tabulku `sl_user_evaluation`
--
ALTER TABLE `sl_user_evaluation`
  ADD CONSTRAINT `sl_user_evaluation_ibfk_1` FOREIGN KEY (`kontakty_id`) REFERENCES `kontakty` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_user_evaluation_ibfk_2` FOREIGN KEY (`author`) REFERENCES `kontakty` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_user_evaluation_ibfk_3` FOREIGN KEY (`edited_user`) REFERENCES `kontakty` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sl_user_evaluation_ibfk_4` FOREIGN KEY (`deleted_user`) REFERENCES `kontakty` (`id`) ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
